% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cog_data_score}
\alias{cog_data_score}
\title{Scored Cognition Data}
\format{
A dataframe with 10 rows and 6 variables:
\describe{
\item{HHID}{Household identifier, a unique 6-digit integer.}
\item{PN}{Person number, a unique 1- or 2-digit integer within each household.}

\item{Total_I}{Total immediate word recall score, ranging from 0 to 5 (sum of 5 items from the immediate recall test).}
\item{Total_D}{Total delayed word recall score, ranging from 0 to 5 (sum of 5 items from the delayed recall test).}

\item{Total_Sub}{Total serial subtraction score, ranging from 0 to 5 (sum of successful subtractions from the serial subtraction test).}

\item{Total_Count}{Total backwards counting score, ranging from 0 to 2 (2 points for success on the first try, 1 point for success on the second try, and 0 for failure).}
}
}
\usage{
cog_data_score
}
\description{
A simulated dataset with scored cognition test results. This dataset contains calculated total scores for immediate recall, delayed recall, serial subtraction.
}
\examples{
# Load the data
data(cog_data_score)

# View the first few rows
head(cog_data_score)

}
\keyword{datasets}
