% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funct_space.R
\name{funct.space.plot}
\alias{funct.space.plot}
\title{Plot species position in a functional space}
\usage{
funct.space.plot(
  sp_faxes_coord,
  faxes = NULL,
  name_file = NULL,
  faxes_nm = NULL,
  range_faxes = c(NA, NA),
  color_bg = "grey95",
  color_pool = "darkturquoise",
  fill_pool = "white",
  shape_pool = 21,
  size_pool = 1,
  plot_ch = TRUE,
  color_ch = "darkblue",
  fill_ch = "white",
  alpha_ch = 1,
  plot_vertices = TRUE,
  color_vert = "darkturquoise",
  fill_vert = "darkturquoise",
  shape_vert = 22,
  size_vert = 1,
  plot_sp_nm = NULL,
  nm_size = 3,
  nm_color = "black",
  nm_fontface = "plain",
  check_input = TRUE
)
}
\arguments{
\item{sp_faxes_coord}{a matrix of species coordinates in a
multidimensional functional space. Species coordinates have been retrieved
thanks to \code{\link{tr.cont.fspace}} or \code{\link{quality.fspaces}}.}

\item{faxes}{a vector with names of axes to plot (as columns names in
\code{sp_faxes_coord}). \strong{You can only plot from 2 to 4 axes for
graphical reasons}. Default: \code{faxes = NULL} (the four first axes will be
plotted).}

\item{name_file}{a character string with name of file to save the
figure (without extension). Default: \code{name_file = NULL} which means plot
is displayed.}

\item{faxes_nm}{a vector with axes labels for figure. Default: as
\code{faxes}).}

\item{range_faxes}{a vector with minimum and maximum values of axes
used for all plots to have a fair representation of position of species.
Default: \code{range_faxes = c(NA, NA)} (the range is computed
according to the range of values among all axes). If at least one of the
value provided is within the range of coordinates, then convex hull could
not be plotted so \code{plot_ch} should be \code{FALSE}.}

\item{color_bg}{a R color name or an hexadecimal code used to fill plot
background. Default: \code{color_bg = "grey95"}.}

\item{color_pool}{a R color name or an hexadecimal code referring to the
color of symbol for species. Default: \code{color_pool = 'darkgreen'}.}

\item{fill_pool}{a R color name or an hexadecimal code referring to the
color to fill species symbol (if \code{shape_pool} >20). Default:
\code{fill_pool = 'white'}.}

\item{shape_pool}{a numeric value referring to the shape of symbol used for
species. Default: \code{shape_pool = 21} (filled circle).}

\item{size_pool}{a numeric value referring to the size of symbol for
species. Default: \code{size_pool = 1}.}

\item{plot_ch}{a logical value indicating whether the convex hull shaping
the pool of species should be illustrated. If \code{plot_ch = TRUE}, convex
hull of all species in the multidimensional space described in
\code{sp_faxes_coord} is computed and its projection in 2D spaces are
drawn as polygons. Default: \code{plot_ch = TRUE}.}

\item{color_ch}{a R color name or an hexadecimal code referring to the
border of the convex hull filled by the pool of species. Default:
\code{color_ch = "darkblue"}.}

\item{fill_ch}{a R color name or an hexadecimal code referring to the
filling of the convex hull filled by the pool of species. Default:
\code{fill_ch = "white"}.}

\item{alpha_ch}{a numeric value for transparency of the filling of the
convex hull (0 = high transparency, 1 = no transparency). Default:
\code{alpha_ch = 1}.}

\item{plot_vertices}{a logical value defining whether vertices of the convex
hull shaping the pool of species should be illustrated. If
\code{plot_vertices = TRUE}, vertices of convex hull computed in the
multidimensional space from \code{sp_faxes_coord} and are plotted with
aesthetics listed below '..._vert' (species not being vertices are plotted
with aesthetics described above for '.._sp'. Default:
\code{plot_vertices = TRUE}.}

\item{color_vert}{a character value referring to the color of symbol for
vertices if \code{plot_vertices = TRUE}.
Default: \code{color_vert = 'darkturquoise'}.}

\item{fill_vert}{a character value referring to the color for filling symbol
for vertices  (if \code{shape_vert} >20). Default:
\code{fill_vert = 'darkturquoise'}.}

\item{shape_vert}{a numeric value referring to the symbol used to show
vertices position if \code{plot_vertices = TRUE}. Default: \code{shape_vert = 23}
(filled diamond).}

\item{size_vert}{a numeric value referring to the size of symbol for
vertices Default: \code{size_vert = 1}.}

\item{plot_sp_nm}{a vector containing species names that are to be printed
near their position. Default: \code{plot_nm_sp = NULL} (no name plotted).}

\item{nm_size}{a numeric value for size of species label. Default is \code{3}
(in points).}

\item{nm_color}{a R color name or an hexadecimal code referring to the color
of species label. Default: \code{nm_color = 'black'}.}

\item{nm_fontface}{a character string for font of species labels (e.g.
"italic", "bold"). Default: \code{nm_fontface = 'plain'}.}

\item{check_input}{a logical value indicating whether key features the
inputs are checked (e.g. class and/or mode of objects, names of rows
and/or columns, missing values). If an error is detected, a detailed
message is returned. Default: \code{check_input = TRUE}.}
}
\value{
If \code{name_file} is \code{NULL}, a list containing \code{ggplot2}
objects is returned: plots of functional space along all pairs of axes
(named according to axes names, e.g. "PC1_PC2"), figure 'caption', and the
full figure 'patchwork' built using the library \code{patchwork}.
If \code{name_file} is not \code{NULL} a 300dpi png file
is saved in the working directory. Ranges of axes are the same for all
panels and if required projection of the convex hull computed in the
multidimensional space provided as input \code{sp_faxes_coord} is
illustrated with a polygon. Species being vertices of this convex hull are
shown with aesthetics provided as inputs \code{..._vert}. Labels for
species listed in \code{plot_sp_nm} are added with if required arrows
using \code{ggrepel}. Summary about species and dimensionality are printed
on top-right corner of the figure.
}
\description{
This function illustrates the position of species along pairs of axes of a
functional space
}
\examples{
# Load Species*Traits dataframe:
 data("fruits_traits", package = "mFD")

# Load Assemblages*Species dataframe:
 data("baskets_fruits_weights", package = "mFD")

# Load Traits categories dataframe:
 data("fruits_traits_cat", package = "mFD")

# Compute functional distance
 sp_dist_fruits <- mFD::funct.dist(sp_tr         = fruits_traits,
                                  tr_cat         = fruits_traits_cat,
                                  metric         = "gower",
                                  scale_euclid   = "scale_center",
                                  ordinal_var    = "classic",
                                  weight_type    = "equal",
                                  stop_if_NA     = TRUE)

# Compute functional spaces quality to retrieve species coordinates matrix:
 fspaces_quality_fruits <- mFD::quality.fspaces(
  sp_dist             = sp_dist_fruits,
  maxdim_pcoa         = 10,
  deviation_weighting = "absolute",
  fdist_scaling       = FALSE,
  fdendro             = "average")

# Retrieve species coordinates matrix:
sp_faxes_coord_fruits <- fspaces_quality_fruits$details_fspaces$sp_pc_coord

# Plot functional spaces:
mFD::funct.space.plot(
 sp_faxes_coord    = sp_faxes_coord_fruits[, c("PC1", "PC2", "PC3", "PC4")],
  faxes             = NULL,
  name_file         = NULL,
  faxes_nm          = NULL,
  range_faxes       = c(NA, NA),
  color_bg          = "grey95",
  color_pool          = "darkturquoise",
  fill_pool           = "white",
  shape_pool          = 21,
  size_pool           = 1,
  plot_ch           = TRUE,
  color_ch          = "darkblue",
  fill_ch           = "white",
  alpha_ch          = 1,
  plot_vertices     = TRUE,
  color_vert        = "darkturquoise",
  fill_vert         = "darkturquoise",
  shape_vert        = 22,
  size_vert         = 1,
 plot_sp_nm         = NULL,
 nm_size            = 3,
 nm_color           = "black",
 nm_fontface        = "plain",
 check_input        = TRUE)
}
\author{
Camille Magneville and Sebastien Villeger
}
