% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkbo_summary.R
\name{mkbo_summary}
\alias{mkbo_summary}
\title{Summarize Components of an mKBO Decomposition}
\usage{
mkbo_summary(x, term = NULL, term.cat = NULL)
}
\arguments{
\item{x}{An object of class \code{"mkbo"}, as returned by the \code{\link{mkbo}} function.}

\item{term}{A character vector specifying one or more model terms (e.g., variable names) for which to summarize decomposition results. Use this argument to inspect contributions from specific variables.}

\item{term.cat}{A character string specifying a common prefix for a group of terms (typically dummy variables from a factor). This will summarize the decomposition results for all terms that match this pattern (e.g., \code{"education"} will match \code{"education.Bachelor"}, \code{"education.Master"}, etc.).}
}
\value{
A \code{data.frame} with one row per group and the following columns:
\describe{
  \item{\code{group}}{Group identifier (from the grouping variable used in \code{mkbo}).}
  \item{\code{M}}{Group-specific mean of the outcome variable.}
  \item{\code{D}}{Difference from the reference (sample mean), as used in the mKBO decomposition.}
  \item{\code{R}}{Total explained difference (sum of E + C + I components).}
  \item{\code{E}}{Component of the difference due to endowments (differences in covariates).}
  \item{\code{C}}{Component due to coefficients (differences in effects).}
  \item{\code{I}}{Interaction component (joint difference in covariates and coefficients, conditional on E and C).}
  }
}
\description{
Provides a summary of the modified Kitagawa-Blinder-Oaxaca (mKBO) decomposition for selected model terms or grouped categories of terms.
This function is useful for inspecting how specific variables (or sets of variables) contribute to the overall decomposition across groups.
}
\examples{
mkbo_output <- mkbo("PERNP ~ BACHELOR", group = "RACE", data=pums_subset)
mkbo_summary(mkbo_output, term="BACHELORTRUE")
}
