% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{string}
\alias{string}
\title{Criterion constructor function to be combined in a custom search statement}
\usage{
string(expr, where, negate = FALSE)
}
\arguments{
\item{expr}{A character string specifying the word or expression to search
for in messages.}

\item{where}{A mandatory character string specifying in which
message's Section or Header Field to search for the provided string.}

\item{negate}{If \code{TRUE}, negates the search and seeks for "NOT SEARCH
CRITERIA". Default is \code{FALSE}.}
}
\description{
Criterion constructor function to be combined in a custom search statement
}
\examples{
\dontrun{
# select folder & search
con$select_folder(name = "INBOX")
# search for messages containing the string "XYZ@k-state.edu" in the
#   "FROM" AND the string "@gmail.com" in the "CC" field.
res <- con$search(request = AND(string(expr = "XYZ@k-state.edu",
                                      where = "FROM"),
                               string(expr = "@gmail.com",
                                      where = "CC")))
}

}
\seealso{
Other custom search: 
\code{\link{AND}()},
\code{\link{ImapCon}},
\code{\link{OR}()},
\code{\link{before}()},
\code{\link{flag}()},
\code{\link{larger_than}()},
\code{\link{older_than}()},
\code{\link{on}()},
\code{\link{sent_before}()},
\code{\link{sent_on}()},
\code{\link{sent_since}()},
\code{\link{since}()},
\code{\link{smaller_than}()},
\code{\link{younger_than}()}
}
\concept{custom search}
