% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{histogram}
\alias{histogram}
\title{Histograms with overlay normal curve}
\usage{
histogram(
  data,
  var,
  breaks = NULL,
  xlab = NULL,
  main = NULL,
  sub = NULL,
  labels = TRUE,
  freq = TRUE,
  curve = TRUE,
  ...
)
}
\arguments{
\item{data}{Dataset}

\item{var}{variable}

\item{breaks}{\link[graphics]{hist}}

\item{xlab}{\link[graphics]{hist}}

\item{main}{\link[graphics]{hist}}

\item{sub}{\link[graphics]{hist}}

\item{labels}{\link[graphics]{hist}}

\item{freq}{\link[graphics]{hist}}

\item{curve}{logical. If \code{TRUE} (default), a normal curve is
overlaid over the histogram.}

\item{...}{\link[graphics]{hist}}
}
\description{
\code{histogram()} draws a histogram with formatted texts and
adds a normal curve over the histogram.
}
\details{
If \code{freq} is set to \code{FALSE}, probability densities,
component density, are plotted (so that the histogram has
a total area of one). In this case, normal curve will not be
generated.
}
\examples{

# histogram(infert, age)
# histogram(infert, age, labels = FALSE)
# histogram(infert, age, freq = FALSE)

}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
