% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{mhrr}
\alias{mhrr}
\title{Calculating Risk Ratios}
\usage{
mhrr(
  data,
  exp,
  case,
  strata = NULL,
  exp_value = NULL,
  case_value = NULL,
  digits = 4
)
}
\arguments{
\item{data}{data.frame}

\item{exp}{exposure or independent variables}

\item{case}{case or dependent variables (outcomes)}

\item{strata}{if specified, MH OR is calculated.}

\item{exp_value}{value for exposure as reference}

\item{case_value}{value for outcome as reference}

\item{digits}{specify rounding of numbers. See \code{\link{round}}.}
}
\description{
\code{mhrr()} calculates different measures of risk including risk
ratios (RR) as well as
Mantel-Haenszel pooled estimates.
}
\details{
Rows and Columns can be rearranged by specifying
\code{exp_value} and \code{case_value}. This is used
when the exposed and case values are not at the right place in 2x2 tables.

Reference row value can be specified in \code{exp_value}.

Attributable fractions, \code{Attr. Frac. Exp} and  \code{Attr. Frac. Pop}
among exposed and population are calculated when RR is greated than or
equal to 1.
If RR is less than 1, preventable fractions,  \code{Prev. Frac. Exp}
and  \code{Attr. Frac. Pop} are calculated.

It produces a table with Risk Ratio, 95\% CI as well as
p-value. If \code{strata} is specified, \code{Mantel-Haenzsel} Pooled
estimates of \verb{Risk Ratio} is generated along with Chi-squared test for
homogeneity.
}
\examples{


### Example from Essential Medical Statistics
# Page 178, Chapter 18: Controlling for confounding: Stratification
lepto <- expandtbl(
    male = c(36, 14, 50, 50), female = c(24, 126, 10, 90),
    exp_name = "area", exp_lvl = c("Rural", "Urban"),
    case_name = "ab", case_lvl = c("Yes", "No"),
    strata_name = "gender"
)

## label variables and data
lepto <- label(lepto, "Prevalence survey of leptospirosis in West Indies")
lepto <- label(lepto, area="Type of area", ab = "Leptospirosis Antibodies",
                  gender="Gener: Male or Female")

## Calculate RR
mhrr(lepto, area, ab)

## Calculate MHRR
mhrr(lepto, area, ab, gender)


\dontrun{
### Demonstration: Calculating Risk Ratios

## Essential Medical Statistics, Betty R. Kirkwood, Second Edition
## Chapter 16, Table 16.4, Page 154
## For Risk Ratio
lung <- expandtbl(
    c(39, 29961, 6, 59994),
    exp_name = "smoking",
    exp_lvl = c("Smokers", "Non-smokers"),
    case_name = "cancer",
    case_lvl = c("Yes", "No")
)

## label variable and dataset
lung <- labelVar(lung, smoking="Yes or No", cancer="Yes or no")
lung <- labelData(lung, "Follow up lung cancer study")

## check dataset
codebook(lung)

## calculate RR
mhrr(lung, smoking, cancer, exp_value = "Smokers", case_value = "Yes")



## Simpson's paradox
## Burt Gerstman's Epidemiology, page 326, table 14.1
simpson <- expandtbl("1" = c(1000, 9000, 50, 950),
                        "2" = c(95, 5, 5000, 5000),
                        exp_name = "trt",
                        exp_lvl = c("new", "standard"),
                        case_name = "case",
                        case_lvl = c("alive", "dead"),
                        strata_name = "clinic")

## calculate RR
mhrr(simpson, trt, case, exp_value = "new", case_value = "alive")

## calculate MH RR
mhrr(simpson, trt, case, clinic)

}

}
\references{
\enumerate{
\item  Betty R. Kirkwood, Jonathan A.C. Sterne (2006, ISBN:978–0–86542–871–3)
\item B. Burt Gerstman (2013, ISBN:978-1-4443-3608-5)
\item Douglas G Altman (2005, ISBN:0 7279 1375 1)
}
}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
