% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mStats.R
\name{strate}
\alias{strate}
\title{Calculate Incidence Rates from time-to-event data}
\usage{
strate(data, time, var, ..., fail = NULL, per = 1, digits = 5)
}
\arguments{
\item{data}{Dataset}

\item{time}{person-time variable}

\item{var}{outcome variable: preferably 1 for event, 0 for censored}

\item{...}{variables for stratified analysis}

\item{fail}{a value or values to specify failure event}

\item{per}{units to be used in reported rates}

\item{digits}{Rounding of numbers}
}
\description{
\code{strate()} calculates incidence rates and Corresponding 95\\% CI.
}
\details{
Rates of event occurrences, known as incidence rates are outcome measures in
longitudinal studies. In most longitudinal studies, follow-up times vary due
to logistic reasons, different periods of recruitment, delay enrollment into
the study, lost-to-follow-up, immigration or emigration and death.

\strong{Follow-up time in longitudinal studies}

Period of observation (called as follow-up time) starts when individuals join
the study and ends when they either have an outcome of interest, are lost-to-
follow-up or the follow-up period ends, whichever happens first. This period is
called \strong{person-year-at-risk}. This is denoted by \emph{PY} in \code{strate}
function's output and number of event by \emph{D}.

\strong{Rate}

is calculated using the following formula:
\deqn{\lambda = D / PY}

\strong{Confidence interval of rate}

is derived using the following formula:

\deqn{95\% CI (rate) = rate x Error Factor}
\deqn{Error Factor (rate) = exp(1.96 / \sqrt{D})}

\code{plot}, if \code{TRUE}, produces a graph of the rates against
the numerical code used for categories of \code{by}.
}
\examples{

\dontrun{

## Using the diet data (Clayton and Hills 1993) described in STATA manual
import diet data: require haven package to read dta format.
magrittr package for piping operation
diet <- haven::read_dta("https://www.stata-press.com/data/r16/diet.dta")

diet <- generate(diet, time, (dox - doe) / 365.25)
diet <- replace(diet, time, as.numeric(time))
diet <- generate(diet, age, as.numeric(doe - dob) / 365.25)
diet <- egen(diet, age, c(41, 51, 61, 71), new_var = ageband)
diet <- egen(diet, month, c(3, 6, 8), new_var = monthgrp)

## calculate overall rates and 95\% Confidence intervals
strate(diet, time, fail, fail = c(1, 3, 13))

## per 100 unit
strate(diet, time, fail, fail = c(1, 3, 13), per = 100)

## calculate Stratified rates and 95\% Confidence Intervals
strate(diet, time, fail, job, fail = c(1, 3, 13))
strate(diet, time, fail, job, ageband, monthgrp, fail = c(1, 3, 13))

## per 100 unit
strate(diet, time, fail, job, ageband, monthgrp, fail = c(1, 3, 13), per = 100)
}

}
\references{
Betty R. Kirkwood, Jonathan A.C. Sterne (2006, ISBN:978–0–86542–871–3)
}
\author{
Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
