% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucher.R
\name{bucher}
\alias{bucher}
\alias{print.maicplus_bucher}
\title{Bucher method for combining treatment effects}
\usage{
bucher(trt, com, conf_lv = 0.95)

\method{print}{maicplus_bucher}(x, ci_digits = 2, pval_digits = 3, exponentiate = FALSE, ...)
}
\arguments{
\item{trt}{a list of two scalars for the study with the
experimental arm. \code{'est'} is the point estimate and \code{'se'}
is the standard error of the treatment effect.
For time-to-event data, \code{'est'} and \code{'se'} should be point estimate and
standard error of the log hazard ratio.
For binary data, \code{'est'} and \code{'se'} should be point estimate and
standard error of the log odds ratio, log risk ratio, or risk
difference.
For continuous data,  \code{'est'} and \code{'se'} should be point estimate and
standard error of the mean difference.}

\item{com}{same as \code{trt}, but for the study with the
control arm}

\item{conf_lv}{a numerical scalar, prescribe confidence level to derive
two-sided confidence interval for the treatment effect}

\item{x}{\code{maicplus_bucher} object}

\item{ci_digits}{an integer, number of decimal places for point
estimate and derived confidence limits}

\item{pval_digits}{an integer, number of decimal places to display
Z-test p-value}

\item{exponentiate}{whether the treatment effect and confidence
interval should be exponentiated. This applies to relative
treatment effects. Default is set to false.}

\item{...}{not used}
}
\value{
a list with 5 elements,
\describe{
\item{est}{a scalar, point estimate of the treatment effect}
\item{se}{a scalar, standard error of the treatment effect}
\item{ci_l}{a scalar, lower confidence limit of a two-sided CI
with prescribed nominal level by \code{conf_lv}}
\item{ci_u}{a scalar, upper confidence limit of a two-sided CI
with prescribed nominal level by \code{conf_lv}}
\item{pval}{p-value of Z-test, with null hypothesis that
\code{est} is zero}
}
}
\description{
Given two treatment effects of A vs. C and B vs. C
derive the treatment effects of A vs. B using the Bucher method.
Two-sided confidence interval and Z-test p-value are also calculated.
Treatment effects and standard errors should be in log scale
for hazard ratio, odds ratio, and risk ratio.
Treatment effects and standard errors should be in natural scale
for risk difference and mean difference.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(maicplus_bucher)}: Print method for \code{maicplus_bucher} objects

}}
\examples{
trt <- list(est = log(1.1), se = 0.2)
com <- list(est = log(1.3), se = 0.18)
result <- bucher(trt, com, conf_lv = 0.9)
print(result, ci_digits = 3, pval_digits = 3)
}
