% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_posterior_diagnostics.R
\name{extract_posterior_parameter}
\alias{extract_posterior_parameter}
\title{Extract the posterior parameter estimate}
\usage{
extract_posterior_parameter(obj, param)
}
\arguments{
\item{obj}{An object from \code{inference_stan}.}

\item{param}{Name of the variance parameter, which is the same as the name of the corresponding
fixed or random effect in the data. Intercept is denoted 'intercept', and residual variance is denoted 'eps'.}
}
\value{
Returns a vector with the posterior samples of the chosen parameter, on variance scale for
variances parameters and original (the common) scale for fixed effect coefficients
}
\description{
Extract the posterior parameter estimate of a random effect variance or fixed effect coefficient
when inference is done with Stan
}
\examples{

if (interactive() && requireNamespace("rstan")){
  ex_prior <- makemyprior_example_model()
  res_stan <- inference_stan(ex_prior, iter = 100)
  # Note: For reliable results, increase the number of iterations (e.g., 'iter = 2000')
  extract_posterior_parameter(res_stan, "intercept")
  extract_posterior_parameter(res_stan, "a")
}

}
\keyword{posterior}
