% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather_spectra_stats.R
\name{gather_spectra_stats}
\alias{gather_spectra_stats}
\title{Aggregate spectra quality-check statistics}
\usage{
gather_spectra_stats(check_vectors)
}
\arguments{
\item{check_vectors}{A list of logical vectors from \link{check_spectra}}
}
\value{
A tibble of one row with the following 5 columns of integers:
\itemize{
\item \code{n_spectra}: total number of raw spectra.
\item \code{n_valid_spectra}: total number of spectra passing all quality checks
\item \code{is_empty}, \code{is_outlier_length} and \code{is_not_regular}: total of spectra flagged with these irregularities.
}
}
\description{
Aggregate spectra quality-check statistics
}
\examples{
# Get an example directory of six Bruker MALDI Biotyper spectra
directory_biotyper_spectra <- system.file(
  "toy-species-spectra",
  package = "maldipickr"
)
# Import the six spectra
spectra_list <- import_biotyper_spectra(directory_biotyper_spectra)
# Display the list of checks, with FALSE where no anomaly is detected
checks <- check_spectra(spectra_list)
# Aggregate the statistics of quality-checked spectra
gather_spectra_stats(checks)
}
\seealso{
\link{check_spectra}
}
