% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm-sentiment.R
\name{llm_sentiment}
\alias{llm_sentiment}
\alias{llm_vec_sentiment}
\title{Sentiment analysis}
\usage{
llm_sentiment(
  .data,
  col,
  options = c("positive", "negative", "neutral"),
  pred_name = ".sentiment",
  additional_prompt = ""
)

llm_vec_sentiment(
  x,
  options = c("positive", "negative", "neutral"),
  additional_prompt = "",
  preview = FALSE
)
}
\arguments{
\item{.data}{A \code{data.frame} or \code{tbl} object that contains the text to be
analyzed}

\item{col}{The name of the field to analyze, supports \code{tidy-eval}}

\item{options}{A vector with the options that the LLM should use to assign
a sentiment to the text. Defaults to: 'positive', 'negative', 'neutral'}

\item{pred_name}{A character vector with the name of the new column where the
prediction will be placed}

\item{additional_prompt}{Inserts this text into the prompt sent to the LLM}

\item{x}{A vector that contains the text to be analyzed}

\item{preview}{It returns the R call that would have been used to run the
prediction. It only returns the first record in \code{x}. Defaults to \code{FALSE}
Applies to vector function only.}
}
\value{
\code{llm_sentiment} returns a \code{data.frame} or \code{tbl} object.
\code{llm_vec_sentiment} returns a vector that is the same length as \code{x}.
}
\description{
Use a Large Language Model (LLM) to perform sentiment analysis
from the provided text
}
\examples{
\donttest{
library(mall)

data("reviews")

llm_use("ollama", "llama3.2", seed = 100, .silent = TRUE)

llm_sentiment(reviews, review)

# Use 'pred_name' to customize the new column's name
llm_sentiment(reviews, review, pred_name = "review_sentiment")

# Pass custom sentiment options
llm_sentiment(reviews, review, c("positive", "negative"))

# Specify values to return per sentiment
llm_sentiment(reviews, review, c("positive" ~ 1, "negative" ~ 0))

# For character vectors, instead of a data frame, use this function
llm_vec_sentiment(c("I am happy", "I am sad"))

# To preview the first call that will be made to the downstream R function
llm_vec_sentiment(c("I am happy", "I am sad"), preview = TRUE)
}
}
