% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riding_binplot.R
\name{riding_binplot}
\alias{riding_binplot}
\title{Canadian federal ridings tile plot function}
\usage{
riding_binplot(riding_data, riding_col = riding_code, value_col,
  continuous = TRUE, arrange = FALSE, riding_border_col = "white",
  year = 2015, riding_border_size = 1, provincial = FALSE,
  shape = "square", province, legend_name = "default")
}
\arguments{
\item{riding_data}{A dataframe with a continuous or categorical riding-level characteristic and a riding code variable.}

\item{riding_col}{An unquoted character expression specifying the riding code variable from the dataframe
provided in \code{riding_data}.}

\item{value_col}{An unquoted character expression specifying the column or categorical riding level characteristic
you would like to visualize.}

\item{continuous}{logical. Specify as \code{FALSE} if the variable is categorical (e.g. for winning party) and \code{TRUE}
if the variable is continuous.}

\item{arrange}{logical. Specify as \code{TRUE} if variable should be ranked according to value within provinces and \code{FALSE}
to plot values according to riding coordinates. Because the binned ridings are only a rough approximation of their actual location,
\code{arrange = TRUE} is often preferable.}

\item{riding_border_col}{To ensure the appearance of stand alone tiles, set `riding_border_col`
to be the same as the background colour of the plot. Default is \code{"white"}.}

\item{year}{Election year. Options are \code{1997}, \code{2000}, \code{2004}, \code{2006}, \code{2008}, \code{2011} and
\code{2015}. This will change the number of tiles to correspond to the number of ridings in the election of the specified year.
Default is \code{2015}}

\item{riding_border_size}{Change the size of tiles. Larger values make smaller tiles. Default is \code{1}.}

\item{provincial}{logical. Specify as FALSE for provincial (not federal) ridings of a single province.
If \code{provincial = TRUE}, specify a 2-letter provincial abbreviation for the province in the \code{province} argument.
Default is \code{FALSE} (i.e. the default is to provide federal electoral boundaries).
(Note: this argument is still in development, only Quebec provincial boundaries are available at the moment.)}

\item{shape}{Unquoted character expression specifying shape of tiles. Options are square and hexagon, default is square.}

\item{province}{An unquoted character expression specifying the 2-letter provincial abbreviation of the province
for which provincial electoral boundaries are desired. (Note: this argument is still in development, only Quebec provincial
boundaries are available at the moment.)}

\item{legend_name}{Quoted chacter expression specifying the title of the legend. The variable name will be used as a default
if no value is supplied.}
}
\description{
A function that returns a data frame with map data, for use in ggplot.
}
\examples{
election_2015 <- federal_election_results[federal_election_results$election_year == 2015, ]

riding_binplot(riding_data = election_2015, riding_col = riding_code,
value_col = party, continuous = FALSE, arrange = TRUE)

}
