% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fitted_model.R
\name{get_fitted_model}
\alias{get_fitted_model}
\title{Get fitted model object}
\usage{
get_fitted_model(fitted_df = NULL, model_name = NULL)
}
\arguments{
\item{fitted_df}{A table with fitted models, as produced by \code{\link[=fit_devmodels]{fit_devmodels()}}.}

\item{model_name}{Character. Name of a fitted model, see \link{available_models}.}
}
\value{
A model object
}
\description{
Get fitted model object
}
\examples{
data("aphid")

fitted_tpcs_aphid <- fit_devmodels(temp = aphid$temperature,
                                   dev_rate = aphid$rate_value,
                                   model_name = c("lactin2", "briere2", "ratkowsky")
                                   )
get_fitted_model(fitted_tpcs_aphid, "briere2")
}
