% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_base.R
\name{mf_base}
\alias{mf_base}
\title{Plot an sf object}
\usage{
mf_base(
  x,
  col,
  border,
  alpha = NULL,
  cex = 1,
  pch = 20,
  lwd = 0.7,
  lty = 1,
  add = FALSE,
  ...
)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{col}{color}

\item{border}{border color}

\item{alpha}{opacity, in the range [0,1]}

\item{cex}{point size}

\item{pch}{pch (point type) for symbols}

\item{lwd}{border width}

\item{lty}{line or border type}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}

\item{...}{ignored}
}
\value{
x is (invisibly) returned.
}
\description{
Plot an sf object. This is mostly a wrapper around
\code{plot(st_geometry(x), ...)}.
}
\examples{
library(sf)
mtq <- mf_get_mtq()
mf_map(mtq, type = "base")
mf_map(mtq, type = "base", col = "blue")
}
\keyword{internal}
