% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maq.R
\name{scale_maq}
\alias{scale_maq}
\title{Scale a Qini curve.}
\usage{
scale_maq(object, scale = 1)
}
\arguments{
\item{object}{A maq object.}

\item{scale}{A numeric value to scale by.}
}
\value{
A maq object with policy values and budget rescaled by the given factor.
}
\description{
Remaps the policy value and budget to application-specific units.
This convenience function is typically useful for plots.
}
\examples{
\donttest{
# Generate some single-arm toy data.
n <- 1500
K <- 1
reward <- matrix(1 + runif(n * K), n, K)
scores <- reward + 5 * matrix(rnorm(n * K), n, K)
cost <- 1

# Fit a Qini curve.
qini <- maq(reward, cost, scores, R = 200)

# Plot the policy values as we vary the fraction treated.
plot(qini, xlab = "Fraction treated")

# Plot the policy values for a maximum allocation of, for example, 500 units.
plot(scale_maq(qini, 500), xlab = "Units treated")

# With R 4.1.0 or later, the native pipe can be used to chain scaling and plotting.
# scale_maq(qini, 500) |>
#   plot(xlab = "Units treated")
}
}
