% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosaicPlot.R
\name{mosaic_plot}
\alias{mosaic_plot}
\alias{mosaic_plot.default}
\alias{mosaic_plot.maraca}
\alias{mosaic_plot.adhce}
\title{Mosaic plot}
\usage{
mosaic_plot(x, ...)

\method{mosaic_plot}{default}(x, ...)

\method{mosaic_plot}{maraca}(
  x,
  theme = "maraca",
  highlight_ties = FALSE,
  win_prob = FALSE,
  diagonal_line = TRUE,
  ...
)

\method{mosaic_plot}{adhce}(
  x,
  step_outcomes = NULL,
  last_outcome = "C",
  arm_levels = c(active = "A", control = "P"),
  theme = "maraca",
  highlight_ties = FALSE,
  win_prob = FALSE,
  diagonal_line = TRUE,
  lowerBetter = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of S3 class 'maraca' or 'adhce'.}

\item{\dots}{not used}

\item{theme}{Choose theme to style the plot. The default theme is "maraca".
Options are "maraca", "color1", "color2" and "none".
For more details, check the vignette called
"Maraca Plots - Introduction to the Mosaic plot".}

\item{highlight_ties}{Flag to indicate if component ties should be
highlighted using lighter colors.
Default value: FALSE}

\item{win_prob}{Flag to indicate if winning probability should be shown
within the plot. Note that in order to display the
winning probability, you need to have set the
"compute_win_odds" to TRUE when creating the maraca
object.
Default value: FALSE}

\item{diagonal_line}{Flag to indicate if diagonal line showing an even
Win/Loss split should be displayed.
Default value: TRUE}

\item{step_outcomes}{A vector of strings containing the outcome labels
for all outcomes displayed as part of the step function
on the left side of the plot.
The order is kept for the plot.
By default (when set to NULL) this is automatically
updated by taking the non-continuous outcomes from
the GROUP variable in alphabetical order.}

\item{last_outcome}{A single string containing the last outcome label
displayed on the right side of the plot.
Default value "C".}

\item{arm_levels}{A named vector of exactly two strings, mapping the
values used for the active and control arms to the values
used in the data. The names must be "active" and "control"
in this order. Note that this parameter only need to
be specified if you have labels different from
 "active" and "control".}

\item{lowerBetter}{Flag for the final outcome variable, indicating if
lower values are considered better/advantageous.
This flag is need to make sure the win odds are
calculated correctly.
Default value is FALSE, meaning higher values
are considered advantageous.}
}
\value{
Mosaic plot as a ggplot2 object.
}
\description{
Generic function to create a mosaic plot that compares outcomes between an
active treatment group and a control group, highlighting areas of "Wins",
"Losses" and "Ties" based on endpoint hierarchy.
}
\details{
Implemented for objects of type 'maraca' and 'adhce'.

Check the vignette "Maraca Plots - Introduction to the Mosaic plot"
for more details.
}
\examples{

data(hce_scenario_a)

maraca_dat <- maraca(data = hce_scenario_a,
                     step_outcomes = c("Outcome I", "Outcome II",
                                      "Outcome III", "Outcome IV"),
                     last_outcome = "Continuous outcome",
                     fixed_followup_days = 3 * 365,
                     column_names = c(outcome = "GROUP",
                                      arm = "TRTP",
                                      value = "AVAL0"),
                     arm_levels = c(active = "Active",
                                    control = "Control"),
                     compute_win_odds = TRUE
                     )

mosaic_plot(maraca_dat)

Rates_A <- c(1.72, 1.74, 0.58, 1.5, 1)
Rates_P <- c(2.47, 2.24, 2.9, 4, 6)
hce_dat <- hce::simHCE(n = 2500, TTE_A = Rates_A, TTE_P = Rates_P,
             CM_A = -3, CM_P = -6, CSD_A = 16, CSD_P = 15, fixedfy = 3,
             seed = 31337)

mosaic_plot(hce_dat)

}
