% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTau.r
\name{getTau}
\alias{getTau}
\title{Compute time scale parameters}
\usage{
getTau(Z.res, T = T, model = c("wn", "ou", "ouf")[1], tau0 = NULL,
  CI = FALSE, method = c("like", "ar")[1])
}
\arguments{
\item{Z.res}{complex vector of isotropic Gaussian, possibly autocorrelated time series of points}

\item{T}{time vector}

\item{model}{one of  \code{"wn"} (white noise),  \code{"ou"} or \code{"ouf"} (case insensitive), denoting, respectively, no autocorrelation, position autocorrelation, or velocity and position autocorrelation.  If \code{model = NULL} and \code{method = "ar"}, the algorithm will select a model using AIC comparisons of the three. If the selected model iswhite noise, the function will return 0's for both parameters.}

\item{tau0}{initial values of parameter estimates - a named vector: \code{c(tau.z = tau0[1], tau.v = tau0[2])}}

\item{CI}{whether or not to compute the confidence intervals (temporarily only available for \code{like} method).}

\item{method}{either \code{"like"} or \code{"ar"}.  The former refers to the likelihood method - it is most general (i.e. works with irregular sampling). The latter refers to the auto-rgressive model equivalence, which is faster but only works with regular sampling.}
}
\description{
A mostly internal function that takes the "residuals" of a range-shift process and estimates \deqn{\tau_z} and, if necessary, \deqn{\tau_v}.
}
