% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickfit.r
\name{quickfit}
\alias{quickfit}
\title{Quick fit of one-step migration}
\usage{
quickfit(T, X, Y, dt = 1, n.clust = 2, plotme = TRUE)
}
\arguments{
\item{T}{time}

\item{X}{x coordinate of movement}

\item{Y}{y coordinate of movement}

\item{dt}{duration of migration (arbitrarily = 1)}

\item{n.clust}{number of clusters (2 or 3)}

\item{plotme}{whether or not to plot the result}
}
\value{
a named vector of initial estimates: 
\itemize{
\item{if \code{n.clust = 2}} {returns \code{t1, dt, x1, y1, x2, y2}} 
\item{if \code{n.clust = 3}} {returns \code{t1, dt1, t2, dt2, x1, y1, x2, y2, x3, y3} }}
}
\description{
Using k-means clustering to get quick fits of 2 or 3 cluster centers in X-Y coordinates.
}
\details{
This function does estimates the locations and times of migration, but not the duration (dt).  It is most useful for obtaining a "null" estimate for seeding the likelihood estimation.
}
\examples{
require(marcher)

## Load simulated data
data(SimulatedTracks)

# plot the MOU simulation
scan_track(MOU.sim)

# quick fit - setting dt = 10
(pm.0 <- with(MOU.sim, quickfit(T, X, Y, dt = 10)))

# interactive locator process
if(interactive()){
 (with(MOU.sim, locate_shift(T, X, Y)))
}

# fit the model
fit <- with(MOU.sim, estimate_shift(T, X, Y))

## Three cluster example

# plot the three range shift simulation
scan_track(MOU.3range)

# quick fit 
## (note - this may not always work!)
with(MOU.3range, quickfit(T, X, Y, dt = 10, n.clust = 3))

if(interactive()){
  with(MOU.3range, locate_shift(T, X, Y, n.clust = 3))
}
}
