% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refit.R
\name{refit}
\alias{refit}
\alias{refit.marginaleffects}
\alias{refit.predictions}
\alias{refit.comparisons}
\alias{refit.slopes}
\alias{refit.hypotheses}
\title{Refit a marginaleffects object with new data}
\usage{
refit(object, ...)

\method{refit}{marginaleffects}(object, data = NULL, newdata = NULL, vcov = NULL, ...)

\method{refit}{predictions}(object, data = NULL, newdata = NULL, vcov = NULL, ...)

\method{refit}{comparisons}(object, data = NULL, newdata = NULL, vcov = NULL, ...)

\method{refit}{slopes}(object, data = NULL, newdata = NULL, vcov = NULL, ...)

\method{refit}{hypotheses}(object, data = NULL, newdata = NULL, vcov = NULL, ...)
}
\arguments{
\item{object}{A marginaleffects object (predictions, comparisons, or slopes)}

\item{...}{Additional arguments passed to methods}

\item{data}{Optional data frame to refit the underlying model}

\item{newdata}{Optional data frame to re-evaluate the marginaleffects call}

\item{vcov}{Optional logical or variance-covariance matrix specification to pass to the marginaleffects call}
}
\value{
A marginaleffects object
}
\description{
Refit a marginaleffects object with new data
}
\details{
If \code{data} is supplied, the underlying model is refitted using that data.
If \code{newdata} is supplied, the marginaleffects call is re-evaluated with the new data.
Both can be supplied together to refit the model and make predictions on new data.
}
