% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjrr.R
\name{margin}
\alias{margin}
\title{Estimates Relative Risks, Risk Differences, and Marginal Effects from Mixed Models}
\usage{
margin(
  fit,
  x,
  type,
  re,
  se,
  at = c(),
  atmeans = c(),
  average = c(),
  xvals = c(1, 0),
  atvals = c(),
  revals = c(),
  oim = FALSE,
  sampling = 250
)
}
\arguments{
\item{fit}{Either a lme4, glmmTMB, or glmmrBase model fit.}

\item{x}{String. Name of the variable to calculate the marginal effect for.}

\item{type}{String. Either `dydx` for derivative, `diff` for difference, or `ratio` for log ratio. See description.}

\item{re}{String. Either `estimated` to condition on estimated values, `zero` to set to zero, `at` to
provide specific values, or `average` to average over the random effects.}

\item{se}{String. Type of standard error to use, either `GLS` for the GLS standard errors, `KR` for
Kenward-Roger estimated standard errors, or `KR2` for the improved Kenward-Roger correction.}

\item{at}{Optional. A vector of strings naming the fixed effects for which a specified value is given.}

\item{atmeans}{Optional. A vector of strings naming the fixed effects that will be set at their mean value.}

\item{average}{Optional. A vector of strings naming the fixed effects which will be averaged over.}

\item{xvals}{Optional. A vector specifying the values of `a` and `b` for `diff` and `ratio`. The default is (1,0).}

\item{atvals}{Optional. A vector specifying the values of fixed effects specified in `at` (in the same order).}

\item{revals}{Optional. If `re="at"` then this argument provides a vector of values for the random effects.}

\item{oim}{Logical. If TRUE use the observed information matrix, otherwise use the expected information matrix for standard error and related calculations.}

\item{sampling}{Integer. Number of MCMC samples to use.}
}
\value{
A named vector with elements `margin` specifying the point estimate and `se` giving the standard error.
}
\description{
Calculates the marginal effect of variable x. There are several options for
marginal effect and several types of conditioning or averaging. The type of marginal
effect can be the derivative of the mean with respect to x (`dydx`), the expected
difference E(y|x=a)-E(y|x=b) (`diff`), or the expected log ratio log(E(y|x=a)/E(y|x=b)) (`ratio`).
Other fixed effect variables can be set at specific values (`at`), set at their mean values
(`atmeans`), or averaged over (`average`). Averaging over a fixed effects variable here means
using all observed values of the variable in the relevant calculation.
The random effects can similarly be set at their
estimated value (`re="estimated"`), set to zero (`re="zero"`), set to a specific value
(`re="at"`), or averaged over (`re="average"`). The standard errors are calculated using the delta method with one
of several options for the variance matrix of the fixed effect parameters.
Several of the arguments require the names
of the variables as given to the model object. Most variables are as specified in the formula,
factor variables are specified as the name of the `variable_value`, e.g. `t_1`. To see the names
of the stored parameters and data variables see the member function `names()`.
}
\examples{
## fit a model using glmmTMB
fit <- glmmTMB::glmmTMB(y ~ Treatment + x1 + x2 + x3 + x4 + (1|Cluster),
  data = trial_data, family = binomial(link="logit"),REML = TRUE)
## relative risk, average over random effects and fixed effects
m1 <- margin(fit,
       x = "Treatment",
       type = "ratio",
       average = c("x1","x2","x3","x4"),
       re = "average",
       se="GLS")
summary(m1)
## stata default for margins command is to set random effects to zero
m2 <- margin(fit,
       x = "Treatment",
       type = "ratio",
       average = c("x1","x2","x3","x4"),
       re = "zero",
       se="GLS")
summary(m2)
## finally estimate a risk difference, with random effects at zero and fixed effects
## at mean values
m3 <- margin(fit,
       x = "Treatment",
       type = "diff",
       atmeans = c("x1","x2","x3","x4"),
       re = "zero",
       se="GLS")
summary(m3)
}
