% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markowitz.R
\name{markowitzcalc}
\alias{markowitzcalc}
\title{Markowitz Criterion}
\arguments{
\item{criterios}{A dataframe with the values of the criteria for each alternative}

\item{lambda_selec}{A number defining the degree of risk appetite}
}
\value{
dataframe with all comparations between alternatives
}
\description{
Implementation of An Markowitz Criterion
More information about the method at  https://doi.org/10.9771/1516-9022rene.v5i2.6769
More information about the implementation at https://github.com/luana1909/Markowtiz/blob/main/DESCRIPTION
}
\examples{
criterios <- data.frame(criterio = c('a1', 'a2', 'a3'),
                        peso = c(0.25, 0.5, 0.25))
alternativas <- data.frame(alternativas = c('outdoor', 'televisao', 'jornal'),
                           a1 = c(12, 36, -3),
                           a2 = c(-6, 12, 60),
                           a3 = c(24, 48, 30))
result <- markowitzcalc(criterios, alternativas)
}
