% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_di.R
\name{G_di}
\alias{G_di}
\title{Diffuse irradiance on Mars inclined surface}
\usage{
G_di(
  Ls,
  phi,
  longitude,
  Ts,
  z = Z(Ls = Ls, phi = phi, Ts = Ts),
  tau,
  al = albedo(latitude = phi, longitude = longitude, tau = tau),
  beta
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{Ts}{Solar time [h]}

\item{z}{Sun zenith angle [deg]. If not provided, calculated from Ls, phi, and Ts}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}

\item{beta}{Surface tilt/slope angle from horizontal [deg]}
}
\value{
Diffuse irradiance on inclined surface [W/m²]
}
\description{
Calculates the diffuse solar irradiance (scattered by atmospheric dust) incident on an
inclined surface on Mars. Accounts for the view factor of the sky from the tilted surface.
}
