% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/I_dh.R
\name{I_dh}
\alias{I_dh}
\title{Diffuse insolation on Mars horizontal surface over time period}
\usage{
I_dh(
  Ls,
  phi,
  longitude,
  tau,
  Ts_start,
  Ts_end,
  al = albedo(latitude = phi, longitude = longitude, tau = tau)
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{Ts_start}{Start of integration period [h]}

\item{Ts_end}{End of integration period [h]}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}
}
\value{
Diffuse insolation over specified time period [Wh/m²]
}
\description{
Calculates the diffuse solar energy (scattered by atmospheric dust) received on a horizontal
surface between specified start and end times. Computed as difference between global and beam insolation.
}
