% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airDensityHASL.R
\name{airDensityHASL}
\alias{airDensityHASL}
\title{Air density estimation using only height above sea level.}
\usage{
airDensityHASL(HASL)
}
\arguments{
\item{HASL}{height altitude above sea level in meters.}
}
\value{
Numeric value of an approximated air density in g cm\eqn{^{-3}}.
}
\description{
Calculates the approximated density of local air using a model that relies
on height above sea level (HASL) information. More accurate alternatives are found
in \code{\link[=airDensity]{airDensity()}} but those require data form environmental conditions
(temperature, barometric pressure and relative humidity).
}
\examples{
airDensityHASL(HASL = 0)    # [g/cm^3]
airDensityHASL(HASL = 1600) # [g/cm^3]
}
\seealso{
\code{\link[=airDensity]{airDensity()}} for better models to predict air density.
}
