% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_grviz.R
\name{plot_grviz}
\alias{plot_grviz}
\title{Plot genealogical tree with Graphviz}
\usage{
plot_grviz(g, file = "", max_zoom = 200)
}
\arguments{
\item{g}{an object of class \code{genealogy}, as returned by \code{\link[=get_genealogy]{get_genealogy()}}.}

\item{file}{an optional file name.
If the file name is specified, then Graphviz will render the genealogical tree to PDF and save in this file.
If the file name is not specified, then the plot will be rendered interactively in the RStudio Viewer panel.}

\item{max_zoom}{a \code{numeric(1)} with the maximum zoom factor when plotting in the Viewer.
If trees are particularly deep or wide, the default maximum zoom of 200x may be insufficient, in which case a value larger than 200 should be supplied.
This option has no effect when plotting to a file.}
}
\value{
If a filename was specified, the full path of the saved file is returned as a \code{character(1)} string.
If no filename was specified, then an \code{htmlwidget} suitable for display in the RStudio Viewer is returned.
}
\description{
Plots a genealogical tree either interactively or to PDF using the Graphviz layout engine.
}
\details{
This function requires the \code{DiagrammeR}, \code{DiagrammeRsvg} and either \code{svgPanZoom} (interactive) or \code{rsvg} (pdf output) packages to be installed.
They are only "Suggests" dependencies as this package supports multiple plotting options.
The presence of these packages will be verified when the function is actually called, providing an opportunity to install them automatically if needed.
}
\examples{
\dontshow{if (interactive() && curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# First, you need to use search_id() to find the mathematician ID for the
# individual(s) you wish to plot, or visit https://mathgenealogy.org/ to look
# up in the browser.

# For example, the package author would get their own tree using
g <- get_genealogy(171971)

# Then use the plot_grviz() function to produce a full genealogical tree
plot_grviz(g)
\dontshow{\}) # examplesIf}
}
\references{
Ellson, J., Gansner, E.R., Koutsofios, E., North, S.C. and Woodhull, G. (2004). “Graphviz and Dynagraph — Static and Dynamic Graph Drawing Tools”. In: Jünger, M., Mutzel, P. (eds) \emph{Graph Drawing Software, Mathematics and Visualization}, 127-148. \doi{10.1007/978-3-642-18638-7_6}.

Iannone, R. and Roy, O. (2024). \emph{DiagrammeR: Graph/Network Visualization}. R package, \url{https://CRAN.R-project.org/package=DiagrammeR}.

Iannone, R. (2016). \emph{DiagrammeRsvg: Export DiagrammeR Graphviz Graphs as SVG}. R package, \url{https://CRAN.R-project.org/package=DiagrammeRsvg}.

Ooms, J. (2024). \emph{rsvg: Render SVG Images into PDF, PNG, (Encapsulated) PostScript, or Bitmap Arrays}. R package, \url{https://CRAN.R-project.org/package=rsvg}.

Riutta, A., Tangelder, J., Russell, K., et al. (2020). \emph{svgPanZoom: R 'Htmlwidget' to Add Pan and Zoom to Almost any R Graphic}. R package, \url{https://CRAN.R-project.org/package=svgPanZoom}.
}
