% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ismember.R
\name{ismembertol}
\alias{ismembertol}
\title{Tolerant alternative to ismember}
\usage{
ismembertol(A, B, rows = FALSE, indices = TRUE)
}
\arguments{
\item{A}{a vector, matrix or dataframe}

\item{B}{another vector, matrix or dataframe}

\item{rows}{if \code{TRUE}, each row of A and each row of B are treated as
single entities}

\item{indices}{if \code{TRUE}, outputs the lowest B index for each match in A}
}
\value{
Same as \code{ismember}
}
\description{
Does the
}
\examples{
x <- t(1:6) * pi
y <- 10 ^ log10(x)

# Show that values are equal, but not identical (due to floating-point error)
all.equal(x, y)
identical(x, y)

# Checking the difference in outputs
ismember(x, y)
ismembertol(x, y)

}
\seealso{
\code{ismember}
}
\author{
Waldir Leoncio
}
