% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squeeze.R
\name{squeeze}
\alias{squeeze}
\title{Squeeze}
\usage{
squeeze(A)
}
\arguments{
\item{A}{input or array matrix}
}
\value{
An array with the same elements as the input array, but with
dimensions of length 1 removed.
}
\description{
Remove dimensions of length 1
}
\details{
This function implements the behavior of the homonimous function on
Matlab. \code{B = squeeze(A)} returns an array with the same elements as the
input array A, but with dimensions of length 1 removed. For example, if A is
a 3-by-1-by-1-by-2 array, then squeeze(A) returns a 3-by-2 matrix. If A is a
row vector, column vector, scalar, or an array with no dimensions of length
1, then squeeze returns the input A.
}
\note{
This is basically a wrapper of drop() with a minor adjustment to adapt
the output to what happens on Matlab
}
\examples{
A <- array(dim = c(2, 1, 2))
A[, , 1] <- c(1, 2)
A[, , 2] <- c(3, 4)
print(A)
squeeze(A)
}
\author{
Waldir Leoncio
}
