% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Performer.R
\name{computeConstants}
\alias{computeConstants}
\title{Select constant items}
\usage{
computeConstants(
  data,
  value,
  group,
  timestamp,
  timestampFormat = c("day", "week", "month", "quater", "year"),
  currentTime,
  thresholdTime = 7,
  use_latest = FALSE
)
}
\arguments{
\item{data}{Dataframe containing item stock data.}

\item{value}{Name of the column variable containing the stock values.}

\item{group}{Name(s) of the column(s) that are used to group stock data. These columns are usually the item ID or item name to group
stock data by items.}

\item{timestamp}{Name of the column including the timestamp. This column should be in Date, POSIX , YY-mm, YYYY-'W'ww, YYYY-mm, YYYY-'Q'q or YYYY format.}

\item{timestampFormat}{Declares in which format the timestamp comes in (i.e., "day", "week", "month", "quarter", "year")}

\item{currentTime}{Qualifying date for the value variable. Date must exist in data and have the same format as timestamp-variable.}

\item{thresholdTime}{Time for which the value shouldn't exceed the threshold value. Number declares the time in the format of timestampFormat.}

\item{use_latest}{boolean value. If TRUE data will expand and dates with noexisting values will be filled up with the latest known values.}
}
\value{
Returns a data frame listing all constant items, the date since when the stock is constant and the value of the stock since this time.
}
\description{
Selects items with a constant value for a specified time period.
}
\examples{
data("Stocks")
constants = computeConstants(data=Stocks,
                             value = "stock",
                             group = "item",
                             timestamp = "date",
                             timestampFormat = "day",
                             currentTime = "2019-07-27",
                             thresholdTime = 7,
                             use_latest = FALSE)
}
\seealso{
\code{\link{computeUnderperformer}} \code{\link{computeOverperformer}}
}
\author{
Leon Binder \email{leon.binder@th-deg.de}

Bernhard Bauer \email{bernhard.bauer@th-deg.de}

Michael Scholz \email{michael.scholz@th-deg.de}
}
