% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{m}
\alias{m}
\title{A shortcut to create matrix defining rows}
\usage{
m(...)
}
\arguments{
\item{...}{Single values, vectors, matrices
and `|` as special symbol which breaks input on
the rows.}
}
\value{
matrix with defines elements
}
\description{
One of the main functionalities of the package.
It is an alternative to standard way we define
matrices in R.
}
\examples{
# Typically, we define matrices like this:
x <- matrix(c(1, 2, 3,
              4, 5, 6,
              7, 8, 9), nrow=3, byrow=TRUE)
x
# However, this way of ceating matices seems to be
# a little bit clunky. Using `matricks`, we can do
# it in more staightforward way dividing our input
# into rows by using special symbol `|`
x <- m(1, 2, 3|
       4, 5, 6|
       7, 8, 9)
x
# Moreover, we can pass to the `m` function
# whole sequences or even matrices.
x <- m(1:5 | 6:10 | 11:15 )
x
# We can combine multiple matrices into one
m(diag(3),     diag(3) * 3|
  diag(3) * 3, diag(3)    )
}
