% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff2.R
\name{diff2}
\alias{diff2}
\title{Fast lagged differences}
\usage{
diff2(x, idxs = NULL, lag = 1L, differences = 1L, ..., useNames = TRUE)
}
\arguments{
\item{x}{A \code{\link[base]{numeric}} \code{\link[base]{vector}} of length
N.}

\item{idxs}{A \code{\link[base]{vector}} indicating subset of elements to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{lag}{An \code{\link[base]{integer}} specifying the lag.}

\item{differences}{An \code{\link[base]{integer}} specifying the order of
difference.}

\item{...}{Not used.}

\item{useNames}{If \code{\link[base]{NA}}, the default behavior of the 
function about naming support is remained. If \code{\link[base:logical]{FALSE}}, 
no naming support is done. Else if \code{\link[base:logical]{TRUE}}, names 
attributes of result are set.}
}
\value{
Returns a \code{\link[base]{numeric}} \code{\link[base]{vector}} of
length N - \code{differences}.
}
\description{
Computes the lagged and iterated differences.
}
\examples{
diff2(1:10)

}
\seealso{
\code{\link[base]{diff}}().
}
\author{
Henrik Bengtsson
}
\keyword{internal}
\keyword{univar}
