% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{rinvwishart}
\alias{rinvwishart}
\title{Inverse-Wishart sampler}
\usage{
rinvwishart(n, nu, Omega, epsilon = 0, checkSymmetry = TRUE)
}
\arguments{
\item{n}{sample size, a positive integer}

\item{nu}{degrees of freedom, must satisfy \code{nu > p-1}, where \code{p} is
the dimension (the order of \code{Omega})}

\item{Omega}{scale matrix, a positive definite real matrix}

\item{epsilon}{threshold to force invertibility in the algorithm; see Details}

\item{checkSymmetry}{logical, whether to check the symmetry of \code{Omega};
if \code{FALSE}, only the upper triangular part of \code{Omega} is used}
}
\value{
A numeric three-dimensional array;
simulations are stacked along the third dimension (see example).
}
\description{
Samples the inverse-Wishart distribution.
}
\details{
The inverse-Wishart distribution with scale matrix
\ifelse{html}{\out{&Omega;}}{\eqn{\Omega}} is
defined as the inverse of the Wishart distribution with scale matrix
\ifelse{html}{\out{&Omega;<sup>-1</sup>}}{\eqn{\Omega^{-1}}}
and same number of degrees of freedom.
    The argument \code{epsilon} is a threshold whose role is to guarantee
the invertibility of the sampled Wishart distributions.
See Details in \code{\link{rwishart}}.
}
\examples{
nu <- 6
p <- 3
Omega <- toeplitz(p:1)
IWsims <- rinvwishart(10000, nu, Omega)
dim(IWsims) # 3 3 10000
apply(IWsims, 1:2, mean) # approximately Omega/(nu-p-1)
# the epsilon argument:
IWsims <- tryCatch(rinvwishart(10000, nu=p+0.001, Omega),
                   error=function(e) e)
IWsims <- tryCatch(rinvwishart(10000, nu=p+0.001, Omega, epsilon=1e-8),
                   error=function(e) e)
}
