% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{print.matrixset}
\alias{print.matrixset}
\title{Print a matrixset}
\usage{
\method{print}{matrixset}(x, ..., n_matrices = 2)
}
\arguments{
\item{x}{\code{matrixset} object to print}

\item{...}{currently not used}

\item{n_matrices}{Number of matrices to display}
}
\value{
Invisibly, the \code{matrixset} object.
}
\description{
When printing a \code{matrixset}:
\itemize{
\item The number of matrices and their dimension is shown
\item Prints each matrix of the object, showing its type and dimension. Full
matrices are shown only for those with 3 rows or less. Otherwise, only
the first and last row is shown. The same also applies for the columns.
\item An exception to the point above: if the number of matrices is greater than
\code{n_matrices}, the first \code{n_matrices} are displayed, while the others will
be named only.
\item The row and column annotations (\code{row_info}/\code{column_info}) are displayed as
\code{tibble} objects.
}
}
\examples{
print(student_results)
print(mrm_plus2015)

}
