% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citation.R
\name{format_batch_ama_citation}
\alias{format_batch_ama_citation}
\title{Format Multiple BibTeX Entries to AMA Citation Style}
\usage{
format_batch_ama_citation(bibtex_entries)
}
\arguments{
\item{bibtex_entries}{A character vector containing one or more BibTeX entries}
}
\value{
If given a single entry, returns a single citation object. If given multiple
  entries, returns a list of citation objects. Each object is of class
  c("bibentry", "character", "citation") containing:
  \item{string}{The original BibTeX entry}
  \item{year}{The publication year as numeric}
  \item{citation}{The formatted AMA citation string}
  \item{keywords}{A vector of keywords}
}
\description{
Processes multiple BibTeX entries and converts them to AMA (American Medical Association)
citation format. Handles article, book, and miscellaneous entry types.
}
\examples{
entries <- c(
  "@article{key1,
    author = {Smith J},
    title = {First Example},
    journal = {Journal One},
    year = {2024}
  }",
  "@book{key2,
    author = {Jones K},
    title = {Second Example},
    publisher = {Publisher},
    year = {2024}
  }"
)
citations <- format_batch_ama_citation(entries)

}
\keyword{internal}
