% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau.R
\name{tau_p}
\alias{tau_p}
\title{Pimentel's tau_b}
\usage{
tau_p(x, y, estimator = "values", p11 = 0, p01 = 0, p10 = 0)
}
\arguments{
\item{x, y}{vectors to be correlated. Must be numeric and have the same
length.}

\item{estimator}{string indicating how the parameters $p_{11}$, $p_{01}$,
$p_{10}$ are to be estimated. The default is 'values', which indicates that
they are estimated based on the entries of x and y. If estimates=='own',
the $p_ji$'s must be given as arguments.}

\item{p11}{probability that a bivariate observation is of the type (m,n),
where m,n>0. Default is 0.}

\item{p01}{probability that a bivariate observation is of the type (0,n),
where n>0.Default is 0.}

\item{p10}{probability that a bivariate observation is of the type (n,0),
where n>0.Default is 0.}
}
\value{
correlation values
}
\description{
Computes the estimator for Kendall's tau_b for zero inflated continuous data
proposed by Pimentel(2009).
}
\keyword{internal}
