% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.maze}
\alias{plot.maze}
\alias{lines.maze}
\title{Plot a maze object}
\usage{
\method{plot}{maze}(x, walls = FALSE, ...)

\method{lines}{maze}(
  x,
  walls = FALSE,
  adjust = c(0, 0),
  openings = NULL,
  openings_direction = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{\link{maze}} object.}

\item{walls}{logical value, indicating that the walls of the maze should be
plotted, rather than the paths through the maze. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link[graphics]{lines}}}

\item{adjust}{A vector by which to adjust the overall position of the maze.
Should be a numeric vector of length 2, indicating the \code{x} and
\code{y} adjustments, respectively.}

\item{openings}{Locations in the maze where a certain wall(s) should not be
drawn (only applies when \code{walls = TRUE}). May be specified as
coordinates, or as a relative description (see
\code{\link{find_maze_refpoint}})}

\item{openings_direction}{Character vector describing which walls should not
be drawn at the locations specified by \code{openings}. See Details.}
}
\value{
Returns \code{NULL}, invisibly.
}
\description{
Plot a maze object
}
\details{
When plotting, the coordinates for locations in the maze are taken from the
indices of the corresponding locations in the matrix representation. This
means that the plot will appear to be flipped vertically relative to the
matrix representation of the maze.

The \code{openings_direction} argument specifies where to create an
  opening (ie. where not to draw walls), relative to a location in the maze
  given by \code{openings}. Possible values are: \code{"left"},
  \code{"right"}, \code{"top"}, \code{"bottom"}, \code{"topleft"},
  \code{"topright"}, \code{"bottomright"}, \code{"bottomleft"}, and
  \code{"all"}. If not specified, this will be set as the first value in
  \code{c("left","right","top","bottom")} to reference a wall that would
  otherwise have been drawn.
}
\examples{
m <- maze(10,10)
plot(m, walls = TRUE)
lines(m, lwd = 5, col = 3)
}
