% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\docType{methods}
\name{sim_data}
\alias{sim_data}
\alias{sim_data,array-method}
\title{Simulate data}
\usage{
sim_data(
  X,
  beta,
  cov,
  k,
  mu,
  rho,
  mean_trend = 1,
  sd_trend = 0.5,
  mean_season = 20,
  sd_season = 0.5,
  mean_cycle = 20,
  sd_cycle = 0.5,
  Dtilde,
  Season,
  vrho,
  lambda
)

\S4method{sim_data}{array}(
  X,
  beta,
  cov,
  k,
  mu,
  rho,
  mean_trend = 1,
  sd_trend = 0.5,
  mean_season = 20,
  sd_season = 0.5,
  mean_cycle = 20,
  sd_cycle = 0.5,
  Dtilde,
  Season,
  vrho,
  lambda
)
}
\arguments{
\item{X}{A (\eqn{n*K})-dimensional matrix containing predictors, where \eqn{n} is the number of observations. \eqn{K=\sum k_i} is the number of all candidate predictors for all target series. The first \eqn{k_1} variables are the set of candidate predictors for the first target series, and the next \eqn{k_2} variables are the set of candidate predictors for the second target series, etc.}

\item{beta}{A (\eqn{K*m})-dimensional matrix containing all candidate predictor series for each target series.}

\item{cov}{A (\eqn{m*m})-dimensional matrix containing covariances}

\item{k}{A \eqn{m}-dimensional array containing the number of candidate predictors for each of the \eqn{m} target series.}

\item{mu}{A \eqn{m}-dimensional array with \eqn{1} representing modeling with trend for this target time series.}

\item{rho}{A \eqn{m}-dimensional array representing the learning rates at which the local trend is updated.}

\item{mean_trend}{A numerical value standing for the mean of the error term of the trend component. The default value is \eqn{1}.}

\item{sd_trend}{A numerical value standing for the standard deviation of the error term of the trend component. The default value is \eqn{0.5}.}

\item{mean_season}{A numerical value standing for the mean of the error term of the seasonal component. The default value is \eqn{20}.}

\item{sd_season}{A numerical value standing for the standard deviation of the error term of the seasonal component. The default value is \eqn{0.5}.}

\item{mean_cycle}{A numerical value standing for the mean of the error term of the cycle component. The default value is \eqn{20}.}

\item{sd_cycle}{A numerical value standing for the standard deviation of the error term of the cycle component. The default value is \eqn{0.5}.}

\item{Dtilde}{A \eqn{m}-dimensional array with \eqn{1} representing level in the trend component.}

\item{Season}{A \eqn{m}-dimensional array  indicating the seasonality for each target series, such as c(12,0).}

\item{vrho}{A \eqn{m}-dimensional array of the decay value parameter of the cycle component for each target series, such as c(0,0.99).}

\item{lambda}{A \eqn{m}-dimensional array of the frequence parameter of the cycle component for each target series, such as c(0,pi/100).}
}
\description{
Generate simulated data in the form of structural time series
}
\examples{
###############Setup###########
n<-505 #n: sample size
m<-2 #m: dimension of target series

cov<-matrix(c(1.1,0.7,0.7,0.9), nrow=2, ncol=2) #covariance matrix of target series 

###############Regression component###########
#coefficients for predictors
beta<-t(matrix(c(2,-1.5,0,4,2.5,0,0,2.5,1.5,-1,-2,0,0,-3,3.5,0.5),nrow=2,ncol=8)) 

set.seed(100)
X1<-rnorm(n,5,5^2)
X4<-rnorm(n,-2,5)
X5<-rnorm(n,-5,5^2)
X8<-rnorm(n,0,100)
X2<-rpois(n, 10)
X6<-rpois(n, 15)
X7<-rpois(n, 20)
X3<-rpois(n, 5)
X<-cbind(X1,X2,X3,X4,X5,X6,X7,X8) 

###############Simulated data################
set.seed(100)
data=sim_data(X=X, beta=beta, cov, k=c(8,8), mu=c(1,1), rho=c(0.6,0.8), 
              Dtilde=c(-1,3), Season=c(100,0), vrho=c(0,0.99), lambda=c(0,pi/100))



}
\references{
\Qiu2018

\Ning2021

\Jammalamadaka2019
}
\author{
Jinwen Qiu \email{qjwsnow_ctw@hotmail.com} Ning Ning \email{patricianing@gmail.com}
}
