% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognormalb.R
\name{Lognormalb}
\alias{Lognormalb}
\alias{dlnormb}
\alias{plnormb}
\alias{qlnormb}
\alias{rlnormb}
\title{The Log Normal Distribution parameterized through its mean and standard deviation.}
\usage{
dlnormb(x, mean = exp(0.5), sd = sqrt(exp(2) - exp(1)), log = FALSE)

plnormb(
  q,
  mean = exp(0.5),
  sd = sqrt(exp(2) - exp(1)),
  lower.tail = TRUE,
  log.p = FALSE
)

qlnormb(
  p,
  mean = exp(0.5),
  sd = sqrt(exp(2) - exp(1)),
  lower.tail = TRUE,
  log.p = FALSE
)

rlnormb(n, mean = exp(0.5), sd = sqrt(exp(2) - exp(1)))
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mean}{the mean of the distribution.}

\item{sd}{the standard deviation of the distribution.}

\item{log, log.p}{logical. if `TRUE` probabilities `p` are given as `log(p)`.}

\item{lower.tail}{logical. if `TRUE`, probabilities are \eqn{P[X \le x]}, otherwise,  \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If `length(n) > 1`, the length is taken to be the number required.}
}
\value{
\samp{dlnormb}  gives the density, \samp{plnormb} gives the distribution function, 
\samp{qlnormb} gives the quantile function, and \samp{rlnormb} generates random deviates.
The length of the result is determined by \samp{n} for \samp{rlnorm}, and is the maximum of the lengths 
of the numerical arguments for the other functions. 
The numerical arguments other than \samp{n} are recycled to the length of the result. 
Only the first elements of the logical arguments are used.

The default \samp{mean} and \samp{sd} are chosen to provide a distribution close to a lognormal with 
\samp{meanlog = 0} and \samp{sdlog = 1}.
}
\description{
Density, distribution function, quantile function and random generation for a log normal distribution whose 
arithmetic mean equals to \samp{mean} and standard deviation equals to \samp{sd}.
}
\details{
This function calls the corresponding density, distribution function, quantile function and random generation 
from the log normal (see \code{\link[stats]{Lognormal}}) after evaluation of \eqn{meanlog = log(mean^2 / sqrt(sd^2+mean^2))} and
\eqn{sqrt{(log(1+sd^2/mean^2))}}
}
\examples{
x <- rlnormb(1E5,3,6)
mean(x) 
sd(x)
dlnormb(1) == dnorm(0)
dlnormb(1) == dlnorm(1)

}
\seealso{
\code{\link[stats]{Lognormal}}
}
\keyword{distribution}
