% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{permutationToEdgelist}
\alias{permutationToEdgelist}
\title{Convert permutation to edge list.}
\usage{
permutationToEdgelist(perm)
}
\arguments{
\item{perm}{[\code{integer}]\cr
Permutation of nodes, e.g., solution of a TSP.}
}
\value{
[\code{matrix(2, length(perm))}] Edge list.
}
\description{
Convert permutation to edge list.
}
\examples{
# first generate a random permutation, e.g., representing
# a roundtrip tour in a graph
perm = sample(1:10)
print(perm)
# now convert into an edge list
permutationToEdgelist(perm)
}
\seealso{
Other transformation functions: 
\code{\link{charVecToEdgelist}()},
\code{\link{edgeListToCharVec}()},
\code{\link{nodelistToEdgelist}()},
\code{\link{permutationToCharVec}()},
\code{\link{prueferToCharVec}()},
\code{\link{prueferToEdgeList}()}
}
\concept{transformation functions}
