% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_cauchy.R
\name{cor_cauchy}
\alias{cor_cauchy}
\title{Calculate Cauchy correlation}
\usage{
cor_cauchy(x, a, alpha, nu = 1, nugget = 0, is.dist = FALSE)
}
\arguments{
\item{x}{A numeric vector, matrix, or array.}

\item{a}{Smooth parameter, \eqn{a>0}.}

\item{alpha}{Scale parameter, \eqn{\alpha\in(0, 1]}.}

\item{nu}{Power parameter, \eqn{\nu>0}. Default is 1.}

\item{nugget}{The nugget effect \eqn{\in[0, 1]}.}

\item{is.dist}{Logical; if TRUE, \code{x} is a distance matrix or an array of
distance matrices.}
}
\value{
Correlations of the same dimension as \code{x}.
}
\description{
Calculate Cauchy correlation
}
\details{
The Cauchy correlation function with scale parameter \eqn{a} and
smooth parameter \eqn{\alpha} has the form
\deqn{C(x)=(1-\text{nugget})(a|x|^{2\alpha} + 1)^{-\nu}+\text{nugget}\cdot
\delta_{x=0},} where \eqn{\delta_{x=0}} is 1 when \eqn{x=0} and 0 otherwise.
}
\examples{
x <- matrix(c(0, 5, 5, 0), nrow = 2)
cor_cauchy(x, a = 1, alpha = 0.5)

x <- matrix(c(0, 5, 5, 0), nrow = 2)
cor_cauchy(x, a = 1, alpha = 0.5, nugget = 0.3, is.dist = TRUE)

}
\references{
Gneiting, T., and Schlather, M. (2004). Stochastic Models That Separate
Fractal Dimension and the Hurst Effect. SIAM Review, 46(2), 269–282.
}
\seealso{
Other correlation functions: 
\code{\link{cor_exp}()},
\code{\link{cor_fs}()},
\code{\link{cor_lagr_askey}()},
\code{\link{cor_lagr_exp}()},
\code{\link{cor_lagr_tri}()},
\code{\link{cor_sep}()},
\code{\link{cor_stat}()},
\code{\link{cor_stat_rs}()}
}
\concept{correlation functions}
