% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cleanup_spaces}
\alias{cleanup_spaces}
\title{Clean up the use of whitespace in a character vector}
\usage{
cleanup_spaces(x, remove_leading = TRUE, remove_trailing = TRUE)
}
\arguments{
\item{x}{Character vector.}

\item{remove_leading}{Logical. If \code{TRUE}, leading whitespace will be removed.}

\item{remove_trailing}{Logical. If \code{TRUE}, trailing whitespace will be removed.}
}
\value{
A character vector.
}
\description{
The function \code{\link[=cleanup_spaces]{cleanup_spaces()}} takes a character vector and input and turns
any uninterrupted stretch of whitespace characters into one single space character.
Moreover, it can also \emph{remove} leading whitespace and trailing whitespace.
}
\examples{
txt <- "  A \\\\t  small      example \\\\n with redundant whitespace    "
cleanup_spaces(txt)
cleanup_spaces(txt, remove_leading = FALSE, remove_trailing = FALSE)
}
