% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnames.R
\name{fnames}
\alias{fnames}
\alias{get_fnames}
\title{Retrieve the names of files in a given path}
\usage{
get_fnames(
  path = ".",
  re_pattern = NULL,
  recursive = TRUE,
  perl = TRUE,
  invert = FALSE
)
}
\arguments{
\item{path}{The location of the files to be listed.}

\item{re_pattern}{Optional regular expression. If present, then only the
filenames that match it are retrieved (unless \code{invert = TRUE}, in which
case those filenames are excluded). The match is done over the absolute
path of the files.}

\item{recursive}{Boolean value. Should the subdirectories of \code{path} also be
searched?}

\item{perl}{Boolean value. Whether \code{re_pattern} should be interpreted as a
PERL flavor of regular expression.}

\item{invert}{Boolean value. If \code{TRUE}, filenames matching \code{re_pattern} are
the only ones retrieved. If \code{FALSE}, filenames matching \code{re_pattern} are
excluded.}
}
\value{
An object of class \code{fnames}, which is a special kind of character
vector storing the absolute paths of the corpus files.
It has additional attributes and methods such as:
\itemize{
\item base \code{\link[=print.freqlist]{print()}}, \code{\link[=as_data_frame]{as_data_frame()}},
\code{\link[=sort]{sort()}} and \code{\link[=summary]{summary()}} (which returns the number of items and of unique items),
\item \code{\link[tibble:as_tibble]{tibble::as_tibble()}},
\item an interactive \code{\link[=explore]{explore()}} method,
\item a function to get the number of items \code{\link[=n_fnames]{n_fnames()}},
\item subsetting methods such as \code{\link[=keep_types]{keep_types()}}, \code{\link[=keep_pos]{keep_pos()}}, etc. including \verb{[]}
subsetting (see \link{brackets}), as well as the specific functions \code{\link[=keep_fnames]{keep_fnames()}}
and \code{\link[=drop_fnames]{drop_fnames()}}.
}

Additional manipulation functions includes \code{\link[=fnames_merge]{fnames_merge()}} to combine
filenames collections and the \code{\link[=short_names]{short_names()}} family of functions to shorten
the names.

Objects of class \code{fnames} can be saved to file with \code{\link[=write_fnames]{write_fnames()}};
these files can be read with \code{\link[=read_fnames]{read_fnames()}}.

It is possible to coerce a character vector into an \code{fnames} object with \code{\link[=as_fnames]{as_fnames()}}.
}
\description{
Build an object of class \code{fnames}.
}
\examples{
\donttest{
cwd_fnames <- get_fnames(recursive = FALSE)
}
cwd_fnames <- as_fnames(c("file1", "file2", "file3"))
cwd_fnames
print(cwd_fnames)
as_data_frame(cwd_fnames)
as_tibble(cwd_fnames)

sort(cwd_fnames)

summary(cwd_fnames)
}
