% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc.R
\name{sort.assoc_scores}
\alias{sort.assoc_scores}
\title{Sort an 'assoc_scores' object}
\usage{
\method{sort}{assoc_scores}(x, decreasing = TRUE, sort_order = "none", ...)
}
\arguments{
\item{x}{Object of class \code{\link{assoc_scores}}.}

\item{decreasing}{Boolean value.

If \code{sort_order = "alpha"} and \code{decreasing = FALSE}, the rows will follow the
alphabetic order of the types. If \code{decreasing = TRUE} instead, it will follow
an inverted alphabetic order (from Z to A). This follows the behavior of
applying \code{sort()} to a character vector: note that the default value is
probably not what you would want.

If \code{sort_order} is a column for which a \emph{lower} value indicates a higher association,
i.e. it's a form of p-value, \code{decreasing = TRUE} will place lower values on top
and higher values at the bottom.

For any other column, \code{decreasing = TRUE} will place higher values on top and
lower values at the bottom.}

\item{sort_order}{Criterion to order the rows. Possible values
are \code{"alpha"} (meaning that the items are to be sorted alphabetically),
\code{"none"} (meaning that the items are not to be sorted) and any present
column name.}

\item{...}{Additional arguments.}
}
\value{
An object of class \code{\link{assoc_scores}}.
}
\description{
Sort a full object of class \code{\link{assoc_scores}} based on some criterion. It's the
same that \code{\link[=print.assoc_scores]{print}} does but with a bit more flexibility.
}
\examples{
a <- c(10,    30,    15,    1)
b <- c(200, 1000,  5000,  300)
c <- c(100,   14,    16,    4)
d <- c(300, 5000, 10000, 6000)
types <- c("four", "fictitious", "toy", "examples")
(scores <- assoc_abcd(a, b, c, d, types = types))

print(scores, sort_order = "PMI")
sorted_scores <- sort(scores, sort_order = "PMI")
sorted_scores

sort(scores, decreasing = FALSE, sort_order = "PMI")
}
