% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/freqlist.R
\name{tot_n_tokens}
\alias{tot_n_tokens}
\alias{tot_n_tokens<-}
\alias{tot_n_tokens<-.freqlist}
\alias{tot_n_tokens.freqlist}
\title{Retrieve or set the total number of tokens}
\usage{
tot_n_tokens(x)

tot_n_tokens(x) <- value

\method{tot_n_tokens}{freqlist}(x) <- value

\method{tot_n_tokens}{freqlist}(x)
}
\arguments{
\item{x}{An object of any of the classes for which the method is implemented.}

\item{value}{Numerical value.}
}
\value{
A number.
}
\description{
These methods retrieve or set the total number of tokens in
the corpus on which the frequency counts are based.
This total number of tokens may be higher than the sum of all frequency
counts in \code{x}, for instance, if \code{x} contains frequency counts
for a selection of items only, and not for all tokens in the corpus.
}
\examples{
x <- freqlist("The man and the mouse.",
              re_token_splitter = "(?xi) [:\\\\s.;,?!\"]+",
              as_text = TRUE)
x
tot_n_tokens(x)

y <- keep_types(x, c("man", "and"))
tot_n_tokens(y)
y

tot_n_tokens(y) <- sum(y)
y
tot_n_tokens(y)
}
\seealso{
Other getters and setters: 
\code{\link{n_tokens}()},
\code{\link{n_types}()},
\code{\link{orig_ranks}()},
\code{\link{ranks}()},
\code{\link{type_names}()}
}
\concept{getters and setters}
