% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conc.R
\name{write_conc}
\alias{write_conc}
\title{Write a concordance to file.}
\usage{
write_conc(x, file = "", sep = "\\t")
}
\arguments{
\item{x}{Object of class \code{\link{conc}}.}

\item{file}{Path to output file.}

\item{sep}{Field separator for the columns in the output file.}
}
\value{
Invisibly, \code{x}.
}
\description{
This function writes an object of class \code{\link{conc}} to a file.
}
\examples{
(d <- conc('A very small corpus.', '\\\\w+', as_text = TRUE))
\dontshow{.old_wd <- setwd(tempdir())}
write_conc(d, "example_data.tab")
(d2 <- read_conc("example_data.tab"))
\dontshow{setwd(.old_wd)}
}
\seealso{
\code{\link[=read_conc]{read_conc()}}

Other writing functions: 
\code{\link{write_assoc}()},
\code{\link{write_fnames}()},
\code{\link{write_freqlist}()},
\code{\link{write_tokens}()},
\code{\link{write_txt}()},
\code{\link{write_types}()}
}
\concept{writing functions}
