% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MH.R
\name{set_MH}
\alias{set_MH}
\title{Set options for Metropolis-Hastings sampling}
\usage{
set_MH(type = "RWTN", scale = 0.025, adaptive = NULL, ...)
}
\arguments{
\item{type}{a character string defining the proposal distribution.
Among supported types are random walk proposals "RWTN",
"RWN" and "RWLN" with truncated normal, normal and log-normal
proposal distributions. Other choices correspond to independence
proposals: "TN" for a truncated normal proposal, "unif" for a
uniform proposal, and "beta" and "gamma" for specific beta and
gamma proposal distributions. Not all types are supported for
a particular parameter; see the specific help of the function
defining the model component of interest to see which proposal
distribution types are supported.}

\item{scale}{in case of the "RWTN" proposal, the (initial) scale of the
distribution.}

\item{adaptive}{in case of the random walk "RWTN" or "RWN"
proposals, whether the scale parameter is adapted based on
acceptance rates during the burnin phase of the MCMC simulation.
The default is \code{TRUE} in these cases.}

\item{...}{additional parameters depending on the proposal type.
Supported arguments are 'l' and 'u' to pass the lower and upper
limits of uniform or random walk truncated normal proposals
(defaults l=0 and u=1), and 'a' and 'b' to pass the shape parameters
of a beta proposal distribution (defaults a = b = 0.5).}
}
\value{
An environment with variables and methods for Metropolis-Hastings
 sampling, for use by other package functions.
}
\description{
Set options for Metropolis-Hastings sampling
}
