% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/referenceInterval.R
\name{nonparRI}
\alias{nonparRI}
\title{Nonparametric Method in Calculation of Reference Interval}
\usage{
nonparRI(x, ind = 1:length(x), conf.level = 0.95)
}
\arguments{
\item{x}{(\code{numeric})\cr numeric measurements from target population.}

\item{ind}{(\code{integer})\cr integer vector for boot process, default is all
elements in \code{x}.}

\item{conf.level}{(\code{numeric})\cr the percentile of reference limit.}
}
\value{
a vector of nonparametric reference interval
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This nonparametric method is used to calculate the reference interval when the
distribution is skewed and the sample size is above to 120 observations.
}
\examples{
data("calcium")
x <- calcium$Value
nonparRI(x)
}
