% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{calc_coverage}
\alias{calc_coverage}
\title{Calculate Coverage Probability and its Monte Carlo Standard Error}
\usage{
calc_coverage(lower_bound, upper_bound, true_param)
}
\arguments{
\item{lower_bound}{A numeric vector of lower bounds of confidence intervals.}

\item{upper_bound}{A numeric vector of upper bounds of confidence intervals, corresponding to `lower_bound`.}

\item{true_param}{The true parameter value that the confidence intervals are intended to estimate.}
}
\value{
A list with two components: `coverage`, the calculated coverage probability of the confidence intervals,
and `coverage_mcse`, the Monte Carlo Standard Error of the coverage. This MCSE provides a measure of the precision
of the coverage probability estimate.
}
\description{
Computes the coverage probability of a confidence interval, defined as the proportion
of times the true parameter value falls within the calculated lower and upper bounds
across a set of simulations. Additionally, calculates the Monte Carlo Standard Error (MCSE)
of the coverage probability to assess the uncertainty associated with this coverage estimate.
This function is useful for evaluating the accuracy and reliability of confidence intervals
generated by statistical models or estimation procedures.
}
\examples{
set.seed(123) # For reproducibility
estimates <- rnorm(100, mean = 50, sd = 10)
ci_lower <- estimates - 1.96 * 10
ci_upper <- estimates + 1.96 * 10
true_param <- 50
coverage_info <- calc_coverage(ci_lower, ci_upper, true_param)
print(coverage_info)
}
