% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcwr.R
\name{mcwr_switch}
\alias{mcwr_switch}
\title{Switch from-state and target state}
\usage{
mcwr_switch(data, ji = as.logical(NA), verbose = FALSE)
}
\arguments{
\item{data}{an mcwr data.frame}

\item{ji}{boolean TRUE/FALSE. If TRUE, the data frame will always be in ji-format
after function conclusion.  That is, if the data are in ij-format
they will be converted to ji-format, and will be left untouched otherwise.}

\item{verbose}{boolan TRUE/FALSE. If TRUE, the function
will display verbose error messages. This is useful if the function tells you that it can neither
find a consistent ji data frame nor a consistent ij data frame. The error messages under option \code{verbose}
may give you a clue about the source of the error.}
}
\value{
A data.frame, suitable for further processing by \code{mcwr_*()} functions.
}
\description{
Change from-state and target state index convention of variable names
}
\details{
The appendix notation follows the ij-notation, where the first index refers to the target state and the
second index to the from-state. This has the advantage of conforming with the conventions of matrix algebra.
p- and r-variables of mcwr data frames, however, generally follow the ji-convention.  The advantage of this is
that sorting the variables alphabetically results in a sensible and intuitive ordering. Therefore, your data
frame variables are required to follow the ji-convention.  The convenience function \code{mcwr_switch()} allows you to
switch between the two conventions.  If you have a consistent data frame in ij-format, running this function
will rename variables according to the ji-convention.  Your data must be in ji-format before you can run any
other of the mcwr functions.  As a brief example, we load data in
ji-format, then switch to ij-format and back:
}
\examples{
data <- mcwr_exampledata(1)
head(data)
data <- mcwr_switch(data)
head(data)
data <- mcwr_switch(data)
head(data)

}
\seealso{
Other mcwr: 
\code{\link{mcwr_check}()},
\code{\link{mcwr_exit}()},
\code{\link{mcwr_expectancies}()},
\code{\link{mcwr_genvars}()}
}
\concept{mcwr}
