% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls.R
\name{vipscores}
\alias{vipscores}
\title{VIP scores for PLS model}
\usage{
vipscores(obj, ncomp = obj$ncomp.selected)
}
\arguments{
\item{obj}{a PLS model (object of class \code{pls})}

\item{ncomp}{number of components to count}
}
\value{
matrix \code{nvar x ny} with VIP score values (columns correspond to responses).
}
\description{
Calculates VIP (Variable Importance in Projection) scores for predictors for given number
of components and response variable.
}
\details{
May take some time in case of large number of predictors Returns results as a column-vector,
with all necessary attributes inherited (e.g. xaxis.values, excluded variables, etc.). If you
want to make a plot use for example: \code{mdaplot(mda.t(v), type = "l")}, where \code{v} is
a vector with computed VIP scores. Or just try \code{\link{plotVIPScores.pls}}.
}
\references{
[1] Il-Gyo Chong, Chi-Hyuck Jun. Chemometrics and Laboratory Systems, 78 (2005), pp. 103-112.
}
