% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L2Lnormalized.R
\name{L2L.normalized}
\alias{L2L.normalized}
\title{Compute normalized version of graph Laplacian matrix}
\usage{
L2L.normalized(L)
}
\arguments{
\item{L}{graph Laplcian matrix}
}
\value{
normalized graph Laplacian matrix
}
\description{
Compute normalized version of graph Laplacian matrix
}
\examples{
# Define exemplary adjacency matrix
p1 <- 10
p2 <- 40
p <- p1 + p2
A <- matrix(rep(0, p * p), p, p)
A[1:p1, 1:p1] <- 1
A[(p1 + 1):p, (p1 + 1):p] <- 1
vizu.mat(A, "adjacency matrix")

# Compute corresponding Laplacian matrix
L <- Adj2Lap(A)
vizu.mat(L, "Laplacian matrix")

# Compute corresponding Laplacian matrix - normalized
L.norm <- L2L.normalized(L)
vizu.mat(L.norm, "L Laplacian matrix (normalized)")

}
